<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Questionnaire extends Model 
{

    protected $table = 'questionnaires';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('evenement_id', 'slug', 'logement', 'nom', 'score', 'statut');
    protected $visible = array('evenement_id', 'slug', 'logement', 'nom', 'score', 'statut');

    public function evenement()
    {
        return $this->belongsTo('App\Models\Evenement', 'evenement_id');
    }

    public function question()
    {
        return $this->hasMany('App\Models\Question', 'questionnaire_id');
    }

}